#ifndef D3DAPPLICATION_H
#define D3DAPPLICATION_H

#include "Application.h"
#include <map>
#include <numeric>
#include <d3d11.h>
#include <d3d11_1.h>
#include <DXGI1_2.h>

#define D3DWINDOWCLASS L"D3DApplicationWndClass"

// fxc player2d.fx /nologo /EVS /Tvs_4_1 /Fhshaders\vs.h
#include "shaders/vs.h"

//fxc player2d.fx /nologo /EPS /Tps_4_1 /Fhshaders\ps.h
#include "shaders/ps.h"

#pragma pack(push,1)
struct SimpleVertex
{
    float Pos[4]; // xyzw
    float Tex[2]; // uv
	SimpleVertex( float x, float y, float z, float w, float u, float v ) 
	{
		Pos[0] = x; Pos[1] = y; Pos[2] = z; Pos[3] = w;
		Tex[0] = u; Tex[1] = v;
	}
};
#pragma pack(pop)

class D3DApplication : public Application
{
public:
	D3DApplication();
	virtual ~D3DApplication();

	virtual void Shutdown();
	virtual int Run();

	static LRESULT CALLBACK WndProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
	virtual LRESULT D3DApplicationWndProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );

protected:
	virtual void InitFrame();
	virtual void Render();
	virtual void Swap();
	virtual void ExitFrame();

protected:
	virtual BOOL SetupInstance( int argc, LPWSTR *argv );

	BOOL InitD3D();
	void ClearD3D();

	HRESULT CreateTextureFromDDSFile( LPCWSTR file, ID3D11ShaderResourceView **srv );
	HRESULT CreateTextureFromWICFile( LPCWSTR file, ID3D11ShaderResourceView **srv );

protected:
	HWND m_hWnd;

	IDXGISwapChain1 *m_pDXGISwapChain1;

	IDXGISwapChain *m_pSwapChain;				// the pointer to the swap chain interface
	ID3D11Device *m_pd3dDevice;					// the pointer to our Direct3D device interface
	ID3D11Device1* m_pd3dDevice1;				//
	ID3D11DeviceContext *m_pd3dDeviceCtx;		// the pointer to our device context
	ID3D11DeviceContext1* m_pd3dDeviceCtx1;		//
	ID3D11RenderTargetView *m_pd3dBackBuffer;	// the pointer to the backbuffer
	ID3D11Buffer *m_pd3dVBuffer;				// the pointer to the vertex buffer holding the quad
	ID3D11Buffer *m_pd3dIBuffer;				// index buffer
	ID3D11SamplerState *m_pd3dSamplerState;		//
	ID3D11BlendState *m_pd3dBlendState;			//

	ID3D11VertexShader *m_pVS;					// the vertex shader used in out pipeline
	ID3D11PixelShader *m_pPS;					// the pixel shader used in out pipeline

	ID3D11InputLayout *m_pd3dLayout;			// the input layout

	DXGI_MODE_DESC m_mode;						// The DirectX mode to use
	D3D_FEATURE_LEVEL m_d3dFeatureLevel;		// The support D3D feature level
	D3D_DRIVER_TYPE m_driverType;				// the driver type

	ID3D11ShaderResourceView* m_pImage;
	ID3D11ShaderResourceView* m_pWarping;
};

#endif // D3DAPPLICATION_H
