// **************************************
// DOME PANO TO SPHERE for WINGS RX
// **************************************
// wraps equirectangular panorama image on dome
// (C) 2018 VIOSO GmbH
// version 1.0 (bf)
// date: 05.11.2018


const float c_PI   =3.141592653589793238462643383279502884197169399375105820974944592308;
 const float c_2PI  =2.0*c_PI;
 const float c_G2R  =c_PI/180.0;
 const float c_G2RH =c_G2R/2.0;
 vec4 winkel= { 180, 90, 30, 60 };
 
 
//@implements: sampler2D
struct DOME_pano2sphere {
    
    sampler2D sampler;
     //@ label: "Azimuth / Position", editor: range,  min: 0, max: 360, range_min: 0, range_max: 360, range_default: 90
    float azimuth;
    //@ label: "Elevation / Height", editor: range,  min: -90, max: 90, range_min: -90, range_max: 90, range_default: 50
    float elevation;
};

vec4 texture(DOME_pano2sphere sa, vec2 tex_coords)
{
    
    vec3 v3D,vTmp;
    vec2 v2D;
    float  c,s,l;
    vec2 pos = tex_coords;
	
	pos.x=1-pos.x;
    
    winkel.x = sa.azimuth;  
    winkel.y = sa.elevation;
    
    
    
    v2D.x=( 2.0*pos.x - 1.0 );
    v2D.y=( 1.0 - 2.0*pos.y );
    
    l= v2D.x*v2D.x + v2D.y*v2D.y;
    
    v3D.x=v2D.x;
    v3D.y=v2D.y;
    v3D.z=sqrt( 1.0 - l );
    
    l=winkel.x*c_G2R;
    
    c=cos(l);
    s=sin(l);
    
    vTmp.x= c*v3D.x - s*v3D.y;
    vTmp.y= s*v3D.x + c*v3D.y;
    vTmp.z=v3D.z;
    l=winkel.y*c_G2R;
    c=cos(l);
    s=sin(l);
    
    v3D.x= c*vTmp.x + s*vTmp.z;
    v3D.y= vTmp.y;
    v3D.z=-s*vTmp.x + c*vTmp.z;
    
    v2D.x=atan( v3D.x, v3D.y );
    v2D.y=atan( v3D.z/length(v3D.xy) );
        
    return texture( sa.sampler, vec2( 0.5 + v2D.x/c_2PI, 0.5 - v2D.y/c_PI));
    
} 