///
/// Copyright (C) 2018 domeprojection.com GmbH.
/// All rights reserved.
/// Contact: domeprojection.com GmbH (support@domeprojection.com)
///
/// This file is part of the dpLib.
///

#ifndef _DPDLLSPEC_H_
#define _DPDLLSPEC_H_

#if defined(_WIN32) || defined(__WIN32__) || defined(__WINDOWS__)
    #define DPLIB_WINDOWS
#else
    #define DPLIB_POSIX
#endif

#ifdef DPLIB_WINDOWS
    #ifdef DPLIB_EXPORTS
        #define DPLIB_API __declspec(dllexport)
    #else
        #define DPLIB_API __declspec(dllimport)
    #endif
#else
    #ifdef DDPLIB_EXPORTS
        #define DPLIB_API __attribute__((visibility("default")))
    #else
        #define DPLIB_API
    #endif

    // define commonly used windows garbage that is used in this project everywhere
    typedef unsigned int DWORD;
    typedef float FLOAT;
    typedef long LONG;
    typedef unsigned int UINT;
    #define MAX_PATH 260

    typedef struct tagRECT
    {
        LONG    left;
        LONG    top;
        LONG    right;
        LONG    bottom;
    } RECT;

#endif

#endif // _DPDLLSPEC_H_
