# domeprojection.com Unity Plugin

The dompeprojection.com Unity Plugin allows to load and apply calibration data generated by ProjectionTools in Unity.

It supports warping, blending and black-level correction on arbitrary screen shapes.

2D, 3D and projection-mapping projects are supported.

Dynamic warping and frustum genration for accurate perspective in moving eyepoint scenarios is supported.
Please note that additional third-party tracker-hardware and related software need to be used to build a complete eyepoint-aware system.

## Requirements
* Unity 2018.3 or newer
* Windows 32/64bit


## Installation

Two options are available:

* A: Copy the package into your [project]/Packages folder, so Unity detects it as an embedded package in your project
* B: or add it as a local package using Unity's package editor. Detailed description in [unity3d documentation](https://docs.unity3d.com/2020.1/Documentation/Manual/upm-ui-local.html).

 ## General plugin setup

1. Add dpCorrection script as component to your main camera (prefered) or any other game object.
2. Drag the maincamera onto dpCorrection script camera slot. The plugin will disable this camera and replace it by a complete camera rig with one camera for each projector. Most camera settings are copied to the individual cameras in the camera rig.
3. Set the path to the correction setup config.xml (relative or absolute pathes supported). It is advisable to put that config.xml in a subfolder of the unity project along with all correction data. That way you can just copy that correction data folder into the build folder later on, so that the build application still find the correction data, no matter where they are copied.
4. Set an optional origin. When set, the cameras, and projection shapes will be placed relative to the origin instead of the main camera, this is especially convenient for dynamic warping setups.

## Builds preparation

1. After first build of the unity project, copy your correction data path into the build folder, so the build has access to correction data at the correct relative path.

## Exporting data for DPUnityPlugin

[ProjectionTools](https://www.domeprojection.com/products/projection-tools) Mapper2d, Mapper3d and MapperPM have a dedicated Unity exporter since version 4.2.
This exporter creates compatible correction data and a config.xml which need to be assigned in the dpCorrection script.

## Further Information

* [Documentation](Documentation/DPUnityPlugin.md)
* [Changelog](CHANGELOG.md)
* [License Agreement](LICENSE.md)
* [Buy license](https://www.domeprojection.com/contact)
* [Support](https://support.domeprojection.com)


